#include "FaceVertexMesh.h"
#include "CoordinateMapping.h"
#include <assert.h>

//void
//cFaceVertexMesh::addTri(const std::vector<int32_t>& triVertexCoords)
//{
//    assert(triVertexCoords.size() == 9);
//    int32_t firstIndex = static_cast<int32_t>(_vertexCoords.size() / 3);
//    int32_t i;
//    for(i = 0; i != 9; ++i)
//    {
//        _vertexCoords.push_back(triVertexCoords[i]);
//    }
//    _vertexIndices.push_back(firstIndex);
//    _vertexIndices.push_back(firstIndex + 1);
//    _vertexIndices.push_back(firstIndex + 2);
//}
void
cFaceVertexMesh::addTri(const int32_t* triVertexCoords)
{
    //assert(triVertexCoords.size() == 9);
    int32_t firstIndex = static_cast<int32_t>(_vertexCoords.size() / 3);
    int32_t i;
    for(i = 0; i != 9; ++i)
    {
        _vertexCoords.push_back(triVertexCoords[i]);
    }
    _vertexIndices.push_back(firstIndex);
    _vertexIndices.push_back(firstIndex + 1);
    _vertexIndices.push_back(firstIndex + 2);
}
    
void
cFaceVertexMesh::applyCoordinateMapping(const cCoordinateMapping& mapping)
{
    for(int32_t i = 0; i != vertices(); ++i)
    {
        mapping.applyTo(&_vertexCoords[i * 3]);
    }
}

// iFaceVertexMesh interface

int32_t
cFaceVertexMesh::faces() const
{
    return static_cast<int32_t>(_vertexIndices.size() / 3);
}
int32_t
cFaceVertexMesh::vertices() const
{
    return static_cast<int32_t>(_vertexCoords.size() / 3);
}
int32_t
cFaceVertexMesh::vertexIndex(int32_t face, int32_t vertexInFace) const
{
    return _vertexIndices[face * 3 + vertexInFace];
}
int32_t
cFaceVertexMesh::vertexX(int32_t vertex) const
{
    return _vertexCoords[vertex * 3 + 0];
}
int32_t
cFaceVertexMesh::vertexY(int32_t vertex) const
{
    return _vertexCoords[vertex * 3 + 1];
}
float
cFaceVertexMesh::vertexZ(int32_t vertex) const
{
    return static_cast<float>(_vertexCoords[vertex * 3 + 2]);
}
int32_t
cFaceVertexMesh::faceAttribute(int32_t, int32_t) const
{
    return -1;
}
